class StatPoint extends UniversalSoldiersPickup;

#exec obj load file=..\Textures\Belt_fx.utx package=Belt_fx

#exec mesh import mesh=StatPoint anivfile=Models\StatPoint_a.3d datafile=Models\StatPoint_d.3d x=0 y=0 z=0 mlod=0
#exec mesh origin mesh=StatPoint x=0 y=0 z=0
#exec mesh sequence mesh=StatPoint seq=All startframe=0 numframes=1

#exec meshmap new meshmap=StatPoint mesh=StatPoint
#exec meshmap scale meshmap=StatPoint x=0.06250 y=0.06250 z=0.12500

auto state Pickup
{	
	function Touch( actor Other )
	{
	local US_PRI IPRI;
	local int D;

		if ( ValidTouch(Other) && Other.IsA('PlayerPawn')) 
			{
			PlayPickupMessage(PlayerPawn(Other));
			PlaySound (PickupSound,,2.5);
			Other.MakeNoise(0.2);
			US_PRI(PlayerPawn(Other).PlayerReplicationInfo).StatPoints += 1;

			// Add wind blowing.
			//Pawn(Other).AmbientSound = sound'SpeedWind';
			//Pawn(Other).SoundRadius = 64;		
			SetRespawn();
			}
	}
	function BeginState()
	{

		SetTimer(1.0,True);
	
	}
}

defaultproperties
{
DrawType=DT_Mesh
Mesh=Mesh'StatPoint'
PickupViewMesh=Mesh'StatPoint'
CollisionRadius=32.00000
CollisionHeight=16.00000
MultiSkins(0)=Texture'StatPointIcon'
MultiSkins(1)=Texture'Belt_fx.ShieldBelt.RedShield'
ScaleGlow=2.000000
bCollideWhenPlacing=True
bRotatingPickup=True
RotationRate=(Roll=12500)
RotationRate=(Pitch=12250)
RotationRate=(Yaw=12000)
PickupMessage="You picked up a statpoint!"
ItemName="statpoint"
RespawnTime=0.000000
PickupSound=Sound'UnrealShare.Generic.RespawnSound'
}
